define(
    [],
    function () {
        'use strict';

        return {
            toEqualWithNormalizedWhitespace: function (util, customEqualityTesters) {
                return {
                    compare: function (actual, expected) {
                        var actualNormalized = actual.trim().replace(/\s+/g, ' ');
                        var result = {
                            pass: util.equals(actualNormalized, expected, customEqualityTesters)
                        }
                        var negateMessageIfPassing = result.pass ? 'not ' : '';

                        result.message = 'Expected normalized "' + actual + '" (normalized to "' + actualNormalized +
                            '") ' + negateMessageIfPassing + 'to be "' + expected + '"';

                        return result;
                    }
                }
            }
        }
    }
);